

<?php $__env->startSection('title', 'Kelola Pengumuman'); ?>

<?php $__env->startSection('content_header'); ?>
<div class="flex flex-col sm:flex-row justify-between items-start sm:items-center">
    <div>
        <h1 class="text-3xl font-extrabold text-transparent bg-clip-text bg-gradient-to-r from-purple-600 to-indigo-600 flex items-center">
            <i class="fas fa-bullhorn text-purple-600 mr-3"></i>
            Kelola Pengumuman
        </h1>
        <p class="text-sm text-gray-500 mt-1 font-medium">Buat pengumuman untuk seluruh siswa atau kelas tertentu.</p>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="grid grid-cols-1 gap-6">
        <div class="bg-white rounded-3xl shadow-xl border border-gray-100 overflow-hidden">
            <div class="p-6 border-b border-gray-100 bg-purple-50/30 flex justify-between items-center">
                <h3 class="text-lg font-bold text-gray-800"><i class="fas fa-list mr-2"></i> Daftar Pengumuman</h3>
                
                
                <a href="<?php echo e(route('announcements.create')); ?>" class="px-4 py-2 bg-indigo-600 text-white rounded-xl shadow hover:bg-indigo-700 transition duration-150 font-bold text-sm flex items-center">
                    <i class="fas fa-plus mr-2"></i> Buat Pengumuman
                </a>
            </div>
            
            <div class="p-0">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-100">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase">Judul</th>
                                <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase">Target</th>
                                <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase">Status</th>
                                <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 uppercase">Tanggal</th>
                                <th class="px-6 py-4 text-center text-xs font-bold text-gray-500 uppercase">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 bg-white">
                            <?php $__empty_1 = true; $__currentLoopData = $announcements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $announcement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50/50 transition">
                                <td class="px-6 py-4">
                                    <div class="font-bold text-gray-800"><?php echo e($announcement->title); ?></div>
                                    <div class="text-sm text-gray-500 truncate w-64"><?php echo e(\Illuminate\Support\Str::limit($announcement->content, 50)); ?></div>
                                </td>
                                <td class="px-6 py-4">
                                    <?php if($announcement->target_type == 'all'): ?>
                                        <span class="px-3 py-1 bg-blue-100 text-blue-700 rounded-full text-xs font-bold">Semua Kelas</span>
                                    <?php else: ?>
                                        <span class="px-3 py-1 bg-amber-100 text-amber-700 rounded-full text-xs font-bold">Kelas <?php echo e($announcement->class->name ?? '-'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4">
                                    <span class="px-3 py-1 <?php echo e($announcement->is_active ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'); ?> rounded-full text-xs font-bold">
                                        <?php echo e($announcement->is_active ? 'Aktif' : 'Tidak Aktif'); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-600">
                                    <?php echo e($announcement->created_at->format('d M Y')); ?>

                                </td>
                                <td class="px-6 py-4 text-center">
                                    <div class="flex justify-center items-center space-x-2">
                                        
                                        <a href="<?php echo e(route('announcements.show', $announcement->id)); ?>" class="text-blue-600 hover:text-blue-800" title="Lihat">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        <a href="<?php echo e(route('announcements.edit', $announcement->id)); ?>" class="text-indigo-600 hover:text-indigo-800" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        
                                        <form action="<?php echo e(route('announcements.destroy', $announcement->id)); ?>" method="POST" class="inline-block" onsubmit="return confirm('Hapus pengumuman ini?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="text-red-500 hover:text-red-700" title="Hapus">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="px-6 py-12 text-center text-gray-500 bg-gray-50">
                                    <i class="far fa-clipboard fa-3x mb-3 text-gray-300"></i>
                                    <p>Belum ada pengumuman yang dibuat.</p>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="p-4 border-t border-gray-100">
                    <?php echo e($announcements->links('pagination::tailwind')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    // Auto-dismiss alerts (jika ada)
    setTimeout(function() {
         $('.alert').fadeOut(400);
    }, 5000);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlte', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\e-absensi-siswa\resources\views/admin/announcements/index.blade.php ENDPATH**/ ?>